{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 06.09.98 - 14:20:14 $                                        =}
{========================================================================}
unit Unit1;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ComCtrls, ExtCtrls, MMSystem, MMPCMSup, MMDesign, MMDSPObj, MMACMCvt,
  MMObj, MMWavOut, MMACMDlg, MMDIBCv, MMLevel, MMConect, MMHook;

type
  TMainForm = class(TForm)
    MMACM1: TMMACM;
    MMWaveOut1: TMMWaveOut;
    MMACMConverter1: TMMACMConverter;
    MMDSPInterface1: TMMDSPInterface;
    MMDesigner1: TMMDesigner;
    btnStart: TButton;
    btnStop: TButton;
    MMConnector1: TMMConnector;
    MMLevel1: TMMLevel;
    procedure btnStartClick(Sender: TObject);
    procedure btnStopClick(Sender: TObject);
    procedure MMDSPInterface1BufferLoad(Sender: TObject; lpWaveHdr: PWaveHdr; var MoreBuffers: Boolean);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure MMWaveOut1BufferFilled(Sender: TObject; lpWaveHdr: PWaveHdr);
  private
  public
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

{------------------------------------------------------------------------------}
procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   // close the device finally
   MMWaveOut1.Close;
end;

{------------------------------------------------------------------------------}
procedure TMainForm.btnStartClick(Sender: TObject);
var
   wfx: TWaveformatEx;

begin
   if MMACM1.ChooseFormat(MMWaveOut1.PWaveFormat,'Select Format') then
   begin
      // setup a PCM format for TMMDSPInterface,
      // we need to know which format you will play
      pcmBuildWaveHeader(@wfx,16,1,22050);

      // set here the source format
      MMDSPInterface1.PWaveFormat := @wfx;

      // set here the destination format
      MMACMConverter1.PWaveFormat := MMACM1.PWaveFormat;

      // start playing
      MMWaveOut1.Start;
   end;
end;

{------------------------------------------------------------------------------}
procedure TMainForm.btnStopClick(Sender: TObject);
begin
   // close the device
   MMWaveOut1.Close;
end;

{------------------------------------------------------------------------------}
procedure TMainForm.MMDSPInterface1BufferLoad(Sender: TObject;
                                             lpWaveHdr: PWaveHdr;
                                             var MoreBuffers: Boolean);
begin
   // Params:
   // lpWaveHdr.lpData         : the buffer
   // lpWaveHdr.dwBufferLength : the required data bytes
   // lpWaveHdr.dwBytesRecorded: Return: number of bytes written to the buffer
   // MoreBuffers              : Return: set to True if you have more data

   { put your uncompressed data in the buffer }

   // we simply clear the buffer in this demo
   FillChar(lpWaveHdr^.lpData^,lpWaveHdr^.dwBufferLength,0);

   // mark how many bytes you have written }
   lpWaveHdr^.dwBytesRecorded := lpWaveHdr^.dwBufferLength;

   // set to True if you have more data to play }
   MoreBuffers := True;
end;

{------------------------------------------------------------------------------}
procedure TMainForm.MMWaveOut1BufferFilled(Sender: TObject; lpWaveHdr: PWaveHdr);
begin
   { here you can grab the compressed data which is playing and do what you whant with it }
   { this event occurs directly before the buffer is send to the driver               }


   //Buffer := lpWaveHdr^.lpData;
   //Size   := lpWaveHdr^.dwBytesRecorded;
end;

end.



